/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

// I also parameterised the loop counts for flexibility and rearranged
// things for efficiency. Though it looks different it is still almost
// the same shader as the original I took from GlsSandbox.com, TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

#define PI 3.141592

//uniform float time;
//uniform vec2 mouse;
//uniform vec2 resolution;

struct Ray {
	vec3 origin;
	vec3 direction;
};
	
struct Sphere {
	vec3 center;
	float radius;
};
	
struct Intersection {
	float Z;
	vec3 position;
	vec3 normal;
	vec2 texcoord;
};
	
vec3 tex(vec2 tc){
	if(mod(float(floor(tc.x) + floor(tc.y)), 2.0) == 0.0){
		return mix(vec3(0.7, 0.7, 0.7), vec3(1.0, 0.0, 0.0), (sin(time)+1.0)*0.5);
	} else {
		return vec3(1.0, 1.0, 1.0);
	}
}
	
vec2 uv(vec3 normal)
{
	return vec2(0.5 + atan(normal.z, normal.x) / (PI), 0.5 - asin(normal.y) / PI);
}

vec2 rotate(vec2 v, float angle)
{
	return vec2(v.x*cos(angle) - v.y*sin(angle), v.x*sin(angle) + v.y*cos(angle));	
}

Intersection intersect(Ray ray, Sphere sphere)
{
	Intersection isec = Intersection(0.,vec3(0),vec3(0),vec2(0)); isec.Z = -1111.0;
	float a = dot(ray.direction, ray.direction);
	float b = 2.0 * dot(ray.direction, (ray.origin - sphere.center));
	float c = dot((ray.origin - sphere.center), (ray.origin - sphere.center)) - sphere.radius * sphere.radius;
	float d = b*b - 4.0*a*c;
	if(d>=0.0){
		isec.Z = min((-b - sqrt(d))/(2.0*a), (-b + sqrt(d))/(2.0*a));
		isec.position = ray.origin + ray.direction * isec.Z;
		isec.normal = (isec.position - sphere.center) / sphere.radius;
		isec.texcoord = uv(isec.normal);
	}
	return isec;
}

vec3 shade(vec3 color, vec3 normal, vec2 texcoord, float NdotL, vec3 lightDir, vec3 lightPos, vec3 viewDir)
{
	vec3 H = normalize(-lightDir + viewDir);
	float NdotH = dot(normal, H);
	float spec = pow(NdotH, 100.0);
	return color*(NdotL>0.0?NdotL+0.025+spec:0.025+spec);	
}

void main( void ) {

	vec2 position = ( scaled_gl_FragCoord.xy / resolution.xy ) - vec2(0.5, 0.5); position.x *= resolution.x/resolution.y;


	vec3 color = vec3(0.0);

	vec3 lightDir = normalize(vec3(1.0 + mouse.x * 20.0, 0.5 + mouse.y * 10.0, sin(time) * 1.5 - 2.0));
	
	Ray camera_ray = Ray(vec3(position.x, position.y + 1.5, -5.0), normalize(vec3(position.x * 0.3, position.y * 0.3 - 0.3, 1.0)));
	
	float radius = 0.5 * (sin(time)+2.0);
	float timem = (sin(time*0.05)+1.0) * 0.5;
	
	Sphere s = Sphere(vec3(cos(time)*radius, sin(time)*0.2 , sin(time)*radius), 0.15);
	Intersection isec = Intersection(0.,vec3(0),vec3(0),vec2(0)), min_isec = intersect(camera_ray, s);
	if(min_isec.Z<0.0) min_isec.Z = 99999999.0;
	
	for(int i = 1; i < 10; i++){
		s.center = vec3(cos(time + float(i)*0.628318)*radius, sin(time+float(i)) * 0.2 , sin(time + float(i)*0.628318)*radius);
		isec = intersect(camera_ray, s);
		if(isec.Z < min_isec.Z && isec.Z > 0.0){
			min_isec = isec;	
		}
	}
		
	if(min_isec.Z>=0.0)
		color = shade(tex(min_isec.texcoord*10.0), min_isec.normal, min_isec.texcoord, dot(lightDir, min_isec.normal), lightDir, vec3(10.0, 2.0, 0.0), normalize(vec3(0.0, - 0.3, 1.0)));
	
	color += pow(1.0/length(position) * 0.1, 2.0) * pow((sin(time)+1.0), 1.1) * 0.5;
	
	gl_FragColor = vec4(color, length(color)*10.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}